"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CSharpFrameHeadingRenderer = CSharpFrameHeadingRenderer;
var _react = _interopRequireDefault(require("react"));
var _default_frame_heading_renderer = require("./default_frame_heading_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CSharpFrameHeadingRenderer({
  stackframe,
  fileDetailComponent: FileDetail
}) {
  var _stackframe$line$numb, _stackframe$line;
  const {
    classname,
    filename,
    function: fn
  } = stackframe;
  const lineNumber = (_stackframe$line$numb = (_stackframe$line = stackframe.line) === null || _stackframe$line === void 0 ? void 0 : _stackframe$line.number) !== null && _stackframe$line$numb !== void 0 ? _stackframe$line$numb : 0;
  if (classname) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FileDetail, null, classname), ' in ', /*#__PURE__*/_react.default.createElement(FileDetail, null, fn), ' in ', /*#__PURE__*/_react.default.createElement(FileDetail, null, filename), lineNumber > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' at ', /*#__PURE__*/_react.default.createElement(FileDetail, null, "line ", lineNumber)));
  } else {
    return /*#__PURE__*/_react.default.createElement(_default_frame_heading_renderer.DefaultFrameHeadingRenderer, {
      fileDetailComponent: FileDetail,
      stackframe: stackframe
    });
  }
}