"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EQLCodeEditor = EQLCodeEditor;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EQLCodeEditor({
  value,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    value: value,
    height: "100px",
    languageId: "plaintext",
    languageConfiguration: {
      autoClosingPairs: [{
        open: '"',
        close: '"'
      }, {
        open: '[',
        close: ']'
      }],
      surroundingPairs: [{
        open: '[',
        close: ']'
      }, {
        open: '"',
        close: '"'
      }],
      onEnterRules: [{
        beforeText: /\bsequence\b/g,
        action: {
          indentAction: _monaco.monaco.languages.IndentAction.Indent,
          appendText: '\t ['
        }
      }]
    },
    options: {
      tabSize: 2,
      automaticLayout: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      lineNumbers: 'off'
    },
    onChange: onChange
  });
}