"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionMetadata = TransactionMetadata;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _helper = require("../helper");
var _ = require("..");
var _use_fetcher = require("../../../../hooks/use_fetcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionMetadata({
  transaction
}) {
  const {
    data: transactionEvent,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/event_metadata/{processorEvent}/{id}', {
      params: {
        path: {
          processorEvent: _common.ProcessorEvent.transaction,
          id: transaction.transaction.id
        },
        query: {
          start: transaction['@timestamp'],
          end: transaction['@timestamp']
        }
      }
    });
  }, [transaction]);
  const sections = (0, _react.useMemo)(() => (0, _helper.getSectionsFromFields)((transactionEvent === null || transactionEvent === void 0 ? void 0 : transactionEvent.metadata) || {}), [transactionEvent === null || transactionEvent === void 0 ? void 0 : transactionEvent.metadata]);
  return /*#__PURE__*/_react.default.createElement(_.MetadataTable, {
    sections: sections,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING
  });
}