"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTraceLogsHref = exports.getNodeLogsHref = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeTypeMapping = {
  host: 'host.name',
  container: 'container.id',
  pod: 'kubernetes.pod.uid'
};
const getNodeLogsHref = (nodeType, id, time, allDatasetsLocator, infraNodeLocator) => {
  if (infraNodeLocator) return infraNodeLocator === null || infraNodeLocator === void 0 ? void 0 : infraNodeLocator.getRedirectUrl({
    nodeId: id,
    nodeType,
    time
  });
  return allDatasetsLocator.getRedirectUrl({
    query: getNodeQuery(nodeType, id),
    ...(time ? {
      timeRange: {
        from: getTimeRangeStartFromTime(time),
        to: getTimeRangeEndFromTime(time)
      }
    } : {})
  });
};
exports.getNodeLogsHref = getNodeLogsHref;
const getTraceLogsHref = (traceId, time, allDatasetsLocator, infraLogsLocator) => {
  const query = `trace.id:"${traceId}" OR (not trace.id:* AND "${traceId}")`;
  if (infraLogsLocator) return infraLogsLocator.getRedirectUrl({
    filter: query,
    time
  });
  return allDatasetsLocator.getRedirectUrl({
    query: {
      language: 'kuery',
      query
    },
    ...(time ? {
      timeRange: {
        from: getTimeRangeStartFromTime(time),
        to: getTimeRangeEndFromTime(time)
      }
    } : {})
  });
};
exports.getTraceLogsHref = getTraceLogsHref;
const getNodeQuery = (type, id) => {
  return {
    language: 'kuery',
    query: `${NodeTypeMapping[type]}: ${id}`
  };
};
const defaultTimeRangeFromPositionOffset = {
  hours: 1
};
const getTimeRangeStartFromTime = time => (0, _moment.default)(time).subtract(defaultTimeRangeFromPositionOffset).toISOString();
const getTimeRangeEndFromTime = time => (0, _moment.default)(time).add(defaultTimeRangeFromPositionOffset).toISOString();