"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedKey = FormattedKey;
exports.FormattedValue = FormattedValue;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _i18n = require("../../../../common/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyValue = _common.euiStyled.span`
  color: ${({
  theme
}) => theme.eui.euiColorMediumShade};
  text-align: left;
`;
function FormattedKey({
  k,
  value
}) {
  if (value == null) {
    return /*#__PURE__*/_react.default.createElement(EmptyValue, null, k);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k);
}
function FormattedValue({
  value
}) {
  if ((0, _lodash.isObject)(value)) {
    return /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(value, null, 4));
  } else if ((0, _lodash.isBoolean)(value) || (0, _lodash.isNumber)(value)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, String(value));
  } else if (!value) {
    return /*#__PURE__*/_react.default.createElement(EmptyValue, null, _i18n.NOT_AVAILABLE_LABEL);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
}