"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyDetailTemplate = DependencyDetailTemplate;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _dependencies = require("../../../../common/dependencies");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_apm_route_path = require("../../../hooks/use_apm_route_path");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _beta_badge = require("../../shared/beta_badge");
var _search_bar = require("../../shared/search_bar/search_bar");
var _span_icon = require("../../shared/span_icon");
var _apm_main_template = require("./apm_main_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DependencyDetailTemplate({
  children
}) {
  const {
    query,
    query: {
      dependencyName,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies');
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const path = (0, _use_apm_route_path.useApmRoutePath)();
  const dependencyMetadataFetch = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/dependencies/metadata', {
      params: {
        query: {
          dependencyName,
          start,
          end
        }
      }
    });
  }, [dependencyName, start, end]);
  const {
    data: {
      metadata
    } = {}
  } = dependencyMetadataFetch;
  const tabs = [{
    key: 'overview',
    href: router.link('/dependencies/overview', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.DependencyDetailOverview.title', {
      defaultMessage: 'Overview'
    }),
    isSelected: path === '/dependencies/overview'
  }, {
    key: 'operations',
    href: router.link('/dependencies/operations', {
      query
    }),
    label: _i18n.i18n.translate('xpack.apm.DependencyDetailOperations.title', {
      defaultMessage: 'Operations'
    }),
    isSelected: path === '/dependencies/operations' || path === '/dependencies/operation',
    append: /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
      icon: "beta"
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageHeader: {
      tabs,
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "l"
      }, /*#__PURE__*/_react.default.createElement("h1", null, dependencyName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_span_icon.SpanIcon, {
        type: metadata === null || metadata === void 0 ? void 0 : metadata.spanType,
        subtype: metadata === null || metadata === void 0 ? void 0 : metadata.spanSubtype
      })))
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    searchBarPlaceholder: _dependencies.unifiedSearchBarPlaceholder
  }), children);
}