"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregatedCriticalPathTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _critical_path_flamegraph = require("../../shared/critical_path_flamegraph");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDetailAggregatedCriticalPath({
  traceSamplesFetchResult
}) {
  const {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      transactionName
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const traceIds = (0, _react.useMemo)(() => {
    var _traceSamplesFetchRes, _traceSamplesFetchRes2;
    return (_traceSamplesFetchRes = (_traceSamplesFetchRes2 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes2 === void 0 ? void 0 : _traceSamplesFetchRes2.traceSamples.map(sample => sample.traceId)) !== null && _traceSamplesFetchRes !== void 0 ? _traceSamplesFetchRes : [];
  }, [traceSamplesFetchResult.data]);
  return /*#__PURE__*/_react.default.createElement(_critical_path_flamegraph.CriticalPathFlamegraph, {
    start: start,
    end: end,
    traceIdsFetchStatus: traceSamplesFetchResult.status,
    traceIds: traceIds,
    serviceName: serviceName,
    transactionName: transactionName
  });
}
const aggregatedCriticalPathTab = {
  dataTestSubj: 'apmAggregatedCriticalPathTabButton',
  key: 'aggregatedCriticalPath',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.aggregatedCriticalPathLabel', {
    defaultMessage: 'Aggregated critical path'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker",
    size: "s",
    style: {
      verticalAlign: 'middle'
    }
  }))),
  component: TransactionDetailAggregatedCriticalPath
};
exports.aggregatedCriticalPathTab = aggregatedCriticalPathTab;