"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuccessfulMigrationCard = SuccessfulMigrationCard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _card_footer_content = require("./card_footer_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SuccessfulMigrationCard() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "checkInCircleFilled",
      color: "success"
    }),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.success.title', {
      defaultMessage: 'Elastic Agent successfully setup!'
    }),
    description: _i18n.i18n.translate('xpack.apm.settings.schema.success.description', {
      defaultMessage: 'Your APM integration is now setup and ready to receive data from your currently instrumented agents. Feel free to review the policies applied to your integtration.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_card_footer_content.CardFooterContent, null)
  });
}