"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneralSettings = GeneralSettings;
var _eui = require("@elastic/eui");
var _public = require("@kbn/advanced-settings-plugin/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_apm_feature_flag = require("../../../../hooks/use_apm_feature_flag");
var _apm_feature_flags = require("../../../../../common/apm_feature_flags");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _bottom_bar_actions = require("../bottom_bar_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getApmSettingsKeys(isProfilingIntegrationEnabled) {
  const keys = [_common.enableComparisonByDefault, _common.defaultApmServiceEnvironment, _common.apmServiceGroupMaxNumberOfServices, _common.enableInspectEsQueries, _common.apmLabsButton, _common.apmAWSLambdaPriceFactor, _common.apmAWSLambdaRequestCostPerMillion, _common.apmEnableServiceMetrics, _common.apmEnableContinuousRollups, _common.enableAgentExplorerView];
  if (isProfilingIntegrationEnabled) {
    keys.push(_common.apmEnableProfilingIntegration);
  }
  return keys;
}
function GeneralSettings() {
  const trackApmEvent = (0, _public2.useUiTracker)({
    app: 'apm'
  });
  const {
    docLinks,
    notifications
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const isProfilingIntegrationEnabled = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.ProfilingIntegrationAvailable);
  const apmSettingsKeys = getApmSettingsKeys(isProfilingIntegrationEnabled);
  const {
    handleFieldChange,
    settingsEditableConfig,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public2.useEditableSettings)('apm', apmSettingsKeys);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return settingsEditableConfig[key].requiresPageReload;
      });
      await saveAll();
      trackApmEvent({
        metric: 'general_settings_save'
      });
      if (reloadPage) {
        window.location.reload();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), apmSettingsKeys.map(settingKey => {
    const editableConfig = settingsEditableConfig[settingKey];
    return /*#__PURE__*/_react.default.createElement(_public.LazyField, {
      key: settingKey,
      setting: editableConfig,
      handleChange: handleFieldChange,
      enableSaving: true,
      docLinks: docLinks.links,
      toasts: notifications.toasts,
      unsavedChanges: unsavedChanges[settingKey]
    });
  }), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.apm.apmSettings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length
  }));
}