"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditCustomLinkFlyout = CreateEditCustomLinkFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _filters_section = require("./filters_section");
var _flyout_footer = require("./flyout_footer");
var _link_section = require("./link_section");
var _save_custom_link = require("./save_custom_link");
var _link_preview = require("./link_preview");
var _documentation = require("./documentation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filtersEmptyState = [{
  key: '',
  value: ''
}];
function CreateEditCustomLinkFlyout({
  onClose,
  onSave,
  onDelete,
  defaults,
  customLinkId
}) {
  var _defaults$filters;
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [label, setLabel] = (0, _react.useState)((defaults === null || defaults === void 0 ? void 0 : defaults.label) || '');
  const [url, setUrl] = (0, _react.useState)((defaults === null || defaults === void 0 ? void 0 : defaults.url) || '');
  const [filters, setFilters] = (0, _react.useState)(defaults !== null && defaults !== void 0 && (_defaults$filters = defaults.filters) !== null && _defaults$filters !== void 0 && _defaults$filters.length ? defaults.filters : filtersEmptyState);
  const isFormValid = !!label && !!url;
  const onSubmit = async event => {
    event.preventDefault();
    setIsSaving(true);
    await (0, _save_custom_link.saveCustomLink)({
      id: customLinkId,
      label,
      url,
      filters,
      toasts
    });
    setIsSaving(false);
    onSave();
  };
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: onSubmit,
    id: "customLink_form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.title', {
    defaultMessage: 'Create link'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.label', {
    defaultMessage: 'Links will be available in the context of transaction details throughout the APM app. You can create an unlimited number of links. You can refer to dynamic variables by using any of the transaction metadata to fill in your URLs. More information, including examples, are available in the'
  }), ' ', /*#__PURE__*/_react.default.createElement(_documentation.Documentation, {
    label: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.label.doc', {
      defaultMessage: 'documentation.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_link_section.LinkSection, {
    label: label,
    onChangeLabel: setLabel,
    url: url,
    onChangeUrl: setUrl
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_filters_section.FiltersSection, {
    filters: filters,
    onChangeFilters: setFilters
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_link_preview.LinkPreview, {
    label: label,
    url: url,
    filters: filters
  })), /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, {
    isSaveButtonEnabled: isFormValid,
    onClose: onClose,
    isSaving: isSaving,
    onDelete: onDelete,
    customLinkId: customLinkId
  })));
}