"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewErrorsTable = ServiceOverviewErrorsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _error_overview_link = require("../../../shared/links/apm/error_overview_link");
var _overview_table_container = require("../../../shared/overview_table_container");
var _get_columns = require("../../../shared/errors_table/get_columns");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 5;
const DEFAULT_SORT = {
  direction: 'desc',
  field: 'occurrences'
};
const INITIAL_STATE_MAIN_STATISTICS = {
  items: [],
  totalItems: 0,
  requestId: undefined
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
function ServiceOverviewErrorsTable({
  serviceName
}) {
  const [tableOptions, setTableOptions] = (0, _react.useState)({
    pageIndex: 0,
    sort: DEFAULT_SORT
  });
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    environment,
    kuery,
    rangeFrom,
    rangeTo,
    offset,
    comparisonEnabled
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    pageIndex,
    sort
  } = tableOptions;
  const {
    direction,
    field
  } = sort;
  const {
    data = INITIAL_STATE_MAIN_STATISTICS,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/errors/groups/main_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end
        }
      }
    }).then(response => {
      const currentPageErrorGroups = (0, _lodash.orderBy)(response.errorGroups, field, direction).slice(pageIndex * PAGE_SIZE, (pageIndex + 1) * PAGE_SIZE);
      return {
        // Everytime the main statistics is refetched, updates the requestId making the comparison API to be refetched.
        requestId: (0, _uuid.v4)(),
        items: currentPageErrorGroups,
        totalItems: response.errorGroups.length
      };
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, start, end, serviceName, pageIndex, direction, field,
  // not used, but needed to trigger an update when offset is changed either manually by user or when time range is changed
  offset,
  // not used, but needed to trigger an update when comparison feature is disabled/enabled by user
  comparisonEnabled]);
  const {
    requestId,
    items,
    totalItems
  } = data;
  const {
    data: errorGroupDetailedStatistics = INITIAL_STATE_DETAILED_STATISTICS,
    status: errorGroupDetailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (requestId && items.length && start && end) {
      return callApmApi('POST /internal/apm/services/{serviceName}/errors/groups/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            numBuckets: 20,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          },
          body: {
            groupIds: JSON.stringify(items.map(({
              groupId: groupId
            }) => groupId).sort())
          }
        }
      });
    }
  },
  // only fetches agg results when requestId changes
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  const errorGroupDetailedStatisticsLoading = errorGroupDetailedStatisticsStatus === _use_fetcher.FETCH_STATUS.LOADING;
  const columns = (0, _get_columns.getColumns)({
    serviceName,
    errorGroupDetailedStatisticsLoading,
    errorGroupDetailedStatistics,
    comparisonEnabled,
    query
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "serviceOverviewErrorsTable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableTitle', {
    defaultMessage: 'Errors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_error_overview_link.ErrorOverviewLink, {
    serviceName: serviceName,
    query: query
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableLinkText', {
    defaultMessage: 'View errors'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: true,
    isEmptyAndNotInitiated: totalItems === 0 && status === _use_fetcher.FETCH_STATUS.NOT_INITIATED
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTable.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTable.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTable.noResults', {
      defaultMessage: 'No errors found'
    }),
    columns: columns,
    items: items,
    pagination: {
      pageIndex,
      pageSize: PAGE_SIZE,
      totalItemCount: totalItems,
      pageSizeOptions: [PAGE_SIZE],
      showPerPageOptions: false
    },
    loading: status === _use_fetcher.FETCH_STATUS.LOADING,
    onChange: newTableOptions => {
      var _newTableOptions$page, _newTableOptions$page2;
      setTableOptions({
        pageIndex: (_newTableOptions$page = (_newTableOptions$page2 = newTableOptions.page) === null || _newTableOptions$page2 === void 0 ? void 0 : _newTableOptions$page2.index) !== null && _newTableOptions$page !== void 0 ? _newTableOptions$page : 0,
        sort: newTableOptions.sort ? {
          field: newTableOptions.sort.field,
          direction: newTableOptions.sort.direction
        } : DEFAULT_SORT
      });
    },
    sorting: {
      enableAllColumns: true,
      sort
    }
  }))));
}