"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceGroupsTour = ServiceGroupsTour;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _elastic_docs_link = require("../../shared/links/elastic_docs_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceGroupsTour({
  tourEnabled,
  dismissTour,
  title,
  content,
  anchorPosition,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.serviceGroups.tour.content.link",
      defaultMessage: "Learn more in the {docsLink}.",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_elastic_docs_link.ElasticDocsLink, {
          section: "/kibana",
          path: "/services.html",
          target: "blank"
        }, _i18n.i18n.translate('xpack.apm.serviceGroups.tour.content.link.docs', {
          defaultMessage: 'docs'
        }))
      }
    })),
    isStepOpen: tourEnabled,
    onFinish: () => {},
    maxWidth: 300,
    minWidth: 300,
    step: 1,
    stepsTotal: 1,
    title: title,
    anchorPosition: anchorPosition,
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmServiceGroupsTourDismissButton",
      color: "text",
      size: "xs",
      onClick: dismissTour
    }, _i18n.i18n.translate('xpack.apm.serviceGroups.tour.dismiss', {
      defaultMessage: 'Dismiss'
    }))
  }, children);
}