"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectServices = SelectServices;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _kuery_bar = require("../../../shared/kuery_bar");
var _service_list_preview = require("./service_list_preview");
var _helpers = require("../../../../context/url_params_context/helpers");
var _service_groups = require("../../../../../common/service_groups");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CentralizedContainer = _styledComponents.default.div`
  display: flex;
  height: 100%;
  justify-content: center;
  align-items: center;
`;
const MAX_CONTAINER_HEIGHT = 600;
const MODAL_HEADER_HEIGHT = 180;
const MODAL_FOOTER_HEIGHT = 80;
const Container = _styledComponents.default.div`
  height: ${MAX_CONTAINER_HEIGHT}px;
`;
function SelectServices({
  serviceGroup,
  isEdit,
  onCloseModal,
  onSaveClick,
  onEditGroupDetailsClick,
  isLoading
}) {
  const [kuery, setKuery] = (0, _react2.useState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) || '');
  const [stagedKuery, setStagedKuery] = (0, _react2.useState)((serviceGroup === null || serviceGroup === void 0 ? void 0 : serviceGroup.kuery) || '');
  const [kueryValidationMessage, setKueryValidationMessage] = (0, _react2.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react2.useEffect)(() => {
    if (isEdit) {
      setKuery(serviceGroup.kuery);
      setStagedKuery(serviceGroup.kuery);
    }
  }, [isEdit, serviceGroup.kuery]);
  const {
    start,
    end
  } = (0, _react2.useMemo)(() => (0, _helpers.getDateRange)({
    rangeFrom: 'now-24h',
    rangeTo: 'now'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [kuery]);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && !(0, _lodash.isEmpty)(kuery)) {
      return callApmApi('GET /internal/apm/service-group/services', {
        params: {
          query: {
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [kuery, start, end], {
    preservePreviousData: true
  });
  const isServiceListPreviewLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const handleOnSubmit = () => {
    if (!stagedKuery) {
      return;
    }
    const {
      message
    } = (0, _service_groups.validateServiceGroupKuery)(stagedKuery);
    setKueryValidationMessage(message);
    if (!message) {
      setKuery(stagedKuery);
    }
  };
  return /*#__PURE__*/_react2.default.createElement(Container, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.title', {
    defaultMessage: 'Select services'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.subtitle', {
    defaultMessage: 'Use a query to select services for this group. The preview shows services that match this query within the last 24 hours.'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_kuery_bar.KueryBar, {
    placeholder: _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.kql', {
      defaultMessage: 'E.g. labels.team: "web"'
    }),
    onSubmit: handleOnSubmit,
    onChange: value => {
      setStagedKuery(value);
    },
    value: kuery,
    suggestionFilter: querySuggestion => {
      if ('field' in querySuggestion) {
        const {
          field: {
            spec: {
              name: fieldName
            }
          }
        } = querySuggestion;
        return (0, _service_groups.isSupportedField)(fieldName);
      }
      return true;
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesButton",
    onClick: handleOnSubmit,
    iconType: !kuery ? 'search' : 'refresh',
    isDisabled: isServiceListPreviewLoading || !stagedKuery
  }, !kuery ? _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.preview', {
    defaultMessage: 'Preview'
  }) : _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.refresh', {
    defaultMessage: 'Refresh'
  })))), kuery && (data === null || data === void 0 ? void 0 : data.items) && /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "success",
    size: "s"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.matchingServiceCount', {
    defaultMessage: '{servicesCount} {servicesCount, plural, =0 {services} one {service} other {services}} match the query',
    values: {
      servicesCount: data === null || data === void 0 ? void 0 : data.items.length
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
    style: {
      height: `calc(75vh - ${MODAL_HEADER_HEIGHT}px - ${MODAL_FOOTER_HEIGHT}px)`,
      maxHeight: MAX_CONTAINER_HEIGHT - MODAL_HEADER_HEIGHT - MODAL_FOOTER_HEIGHT
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, !data && isServiceListPreviewLoading && /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, null), kueryValidationMessage !== null && kueryValidationMessage !== void 0 && kueryValidationMessage.length ? /*#__PURE__*/_react2.default.createElement(CentralizedContainer, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.serviceGroups.searchResults.error', {
      defaultMessage: 'Error retrieving search results'
    }),
    color: "danger",
    iconType: "error"
  }, /*#__PURE__*/_react2.default.createElement("p", {
    css: (0, _react.css)`
                        white-space: break-spaces;
                        font-family: ${euiTheme.font.familyCode};
                      `,
    "data-test-subj": "discoverErrorCalloutMessage"
  }, kueryValidationMessage))) : kuery && data ? /*#__PURE__*/_react2.default.createElement(_service_list_preview.ServiceListPreview, {
    items: data.items,
    isLoading: isServiceListPreviewLoading
  }) : /*#__PURE__*/_react2.default.createElement(CentralizedContainer, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.panelLabel', {
    defaultMessage: 'Enter a query to select services'
  }))))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesEditGroupDetailsButton",
    color: "text",
    onClick: onEditGroupDetailsClick,
    iconType: "sortLeft",
    isDisabled: isLoading
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.editGroupDetails', {
    defaultMessage: 'Edit group details'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmSelectServicesCancelButton",
    onClick: onCloseModal,
    isDisabled: isLoading
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmSelectServicesSaveGroupButton",
    fill: true,
    onClick: () => {
      onSaveClick({
        ...serviceGroup,
        kuery
      });
    },
    isDisabled: isLoading || !kuery || !(0, _lodash.isEmpty)(kueryValidationMessage)
  }, _i18n.i18n.translate('xpack.apm.serviceGroups.selectServicesForm.saveGroup', {
    defaultMessage: 'Save group'
  }))))));
}