"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.goVariables = exports.goLineNumbers = exports.goHighlightLang = exports.go = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const goVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'ELASTIC_APM_SECRET_TOKEN'
  }),
  ...(!secretToken && {
    apiKey: 'ELASTIC_APM_API_KEY'
  }),
  apmServerUrl: 'ELASTIC_APM_SERVER_URL'
});
exports.goVariables = goVariables;
const goHighlightLang = 'go';
exports.goHighlightLang = goHighlightLang;
const goLineNumbers = () => ({
  start: 1,
  highlight: '4, 7, 10, 13'
});
exports.goLineNumbers = goLineNumbers;
const go = `# ${_i18n.i18n.translate('xpack.apm.onboarding.goClient.configure.commands.initializeUsingEnvironmentVariablesComment', {
  defaultMessage: 'Initialize using environment variables:'
})}

# {{serviceNameHint}} ${_i18n.i18n.translate('xpack.apm.onboarding.goClient.configure.commands.usedExecutableNameComment', {
  defaultMessage: 'If not specified, the executable name will be used.'
})}
export ELASTIC_APM_SERVICE_NAME=<your-service-name>

{{^secretToken}}
# {{apiKeyHint}}
export ELASTIC_APM_API_KEY={{{apiKey}}}
{{/secretToken}}
{{#secretToken}}
# {{secretTokenHint}}
export ELASTIC_APM_SECRET_TOKEN={{{secretToken}}}
{{/secretToken}}

# {{{serverUrlHint}}}
export ELASTIC_APM_SERVER_URL={{{apmServerUrl}}}

# {{{serviceEnvironmentHint}}}
export ELASTIC_APM_ENVIRONMENT=<your-environment>
`;
exports.go = go;