"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.djangoVariables = exports.djangoLineNumbers = exports.djangoHighlightLang = exports.django = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const djangoVariables = secretToken => ({
  ...(secretToken && {
    secretToken: 'SECRET_TOKEN'
  }),
  ...(!secretToken && {
    apiKey: 'API_KEY'
  }),
  apmServerUrl: 'SERVER_URL'
});
exports.djangoVariables = djangoVariables;
const djangoHighlightLang = 'py';
exports.djangoHighlightLang = djangoHighlightLang;
const djangoLineNumbers = () => ({
  start: 1,
  highlight: '1, 3, 5, 7, 9, 12, 15, 18-19, 21, 23, 25'
});
exports.djangoLineNumbers = djangoLineNumbers;
const django = `INSTALLED_APPS = (
  # ${_i18n.i18n.translate('xpack.apm.onboarding.djangoClient.configure.commands.addAgentComment', {
  defaultMessage: 'Add the agent to installed apps'
})}
  'elasticapm.contrib.django',
  # ...
)

ELASTIC_APM = {
  # {{serviceNameHint}}
  'SERVICE_NAME': '<your-service-name>',

  {{^secretToken}}
  # {{apiKeyHint}}
  'API_KEY': '{{{apiKey}}}',
  {{/secretToken}}
  {{#secretToken}}
  # {{secretTokenHint}}
  'SECRET_TOKEN': '{{{secretToken}}}',
  {{/secretToken}}

  # {{{serverUrlHint}}}
  'SERVER_URL': '{{{apmServerUrl}}}',

  # {{{serviceEnvironmentHint}}}
  'ENVIRONMENT': '<your-environment>',
}

MIDDLEWARE = (
  # ${_i18n.i18n.translate('xpack.apm.onboarding.djangoClient.configure.commands.addTracingMiddlewareComment', {
  defaultMessage: 'Add our tracing middleware to send performance metrics'
})}
  'elasticapm.contrib.django.middleware.TracingMiddleware',
  #...
)`;
exports.django = django;