"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsList = StatsList;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _managed_table = require("../../../../../shared/managed_table");
var _get_columns = require("./get_columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StatsList({
  isLoading,
  mainStatistics,
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  offset
}) {
  const columns = (0, _react.useMemo)(() => {
    return (0, _get_columns.getColumns)({
      detailedStatisticsLoading,
      detailedStatistics,
      comparisonEnabled,
      offset
    });
  }, [detailedStatisticsLoading, detailedStatistics, comparisonEnabled, offset]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: isLoading ? _i18n.i18n.translate('xpack.apm.mobile.stats.table.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.mobile.stats.table.noDataMessage', {
      defaultMessage: 'No data found'
    }),
    items: mainStatistics,
    columns: columns,
    sortItems: false,
    initialPageSize: 25,
    isLoading: isLoading
  });
}