"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayerList = getLayerList;
var _get_http_requests_map_layer_list = require("./get_http_requests_map_layer_list");
var _get_session_map_layer_list = require("./get_session_map_layer_list");
var _constants = require("../../../../../../../common/mobile/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLayerList({
  selectedMap,
  maps,
  dataViewId
}) {
  switch (selectedMap) {
    case _constants.MapTypes.Http:
      return (0, _get_http_requests_map_layer_list.getHttpRequestsLayerList)(maps, dataViewId);
    case _constants.MapTypes.Session:
      return (0, _get_session_map_layer_list.getSessionMapLayerList)(maps, dataViewId);
    default:
      return (0, _get_http_requests_map_layer_list.getHttpRequestsLayerList)(maps, dataViewId);
  }
}