"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessMetricsDetails = ServerlessMetricsDetails;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _serverless_metrics = require("../../metrics/serverless_metrics");
var _serverless = require("../../../../../common/serverless");
var _use_breadcrumb = require("../../../../context/breadcrumbs/use_breadcrumb");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_apm_params = require("../../../../hooks/use_apm_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServerlessMetricsDetails({
  serverlessId
}) {
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const {
    path,
    query
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics/{id}');
  const serverlessFunctionName = (0, _react.useMemo)(() => (0, _serverless.getServerlessFunctionNameFromId)(serverlessId), [serverlessId]);
  (0, _use_breadcrumb.useBreadcrumb)(() => ({
    title: serverlessFunctionName,
    href: apmRouter.link('/services/{serviceName}/metrics/{id}', {
      path,
      query
    })
  }), [apmRouter, path, query, serverlessFunctionName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, serverlessFunctionName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_serverless_metrics.ServerlessMetrics, {
    serverlessId: serverlessId
  })));
}