"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metrics = Metrics;
var _react = _interopRequireDefault(require("react"));
var _agent_name = require("../../../../common/agent_name");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _serverless_metrics = require("./serverless_metrics");
var _service_metrics = require("./service_metrics");
var _jvm_metrics_overview = require("./jvm_metrics_overview");
var _static_dashboard = require("./static_dashboard");
var _helper = require("./static_dashboard/helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Metrics() {
  const {
    agentName,
    runtimeName,
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isAWSLambda = (0, _agent_name.isAWSLambdaAgentName)(serverlessType);
  if (isAWSLambda) {
    return /*#__PURE__*/_react.default.createElement(_serverless_metrics.ServerlessMetrics, null);
  }
  const hasStaticDashboard = (0, _helper.hasDashboardFile)({
    agentName,
    runtimeName,
    serverlessType
  });
  if (hasStaticDashboard) {
    return /*#__PURE__*/_react.default.createElement(_static_dashboard.JsonMetricsDashboard, {
      agentName: agentName,
      runtimeName: runtimeName,
      serverlessType: serverlessType
    });
  }
  if (!isAWSLambda && ((0, _agent_name.isJavaAgentName)(agentName) || (0, _agent_name.isJRubyAgentName)(agentName, runtimeName))) {
    return /*#__PURE__*/_react.default.createElement(_jvm_metrics_overview.JvmMetricsOverview, null);
  }
  return /*#__PURE__*/_react.default.createElement(_service_metrics.ServiceMetrics, null);
}