"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.invalidLicenseMessage = exports.SERVICE_MAP_TIMEOUT_ERROR = void 0;
exports.isSpanGroupingSupported = isSpanGroupingSupported;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// These should be imported, but until TypeScript 4.2 we're inlining them here.
// All instances of "agent.name", "service.name", "service.environment", "span.type",
// "span.subtype", and "span.destination.service.resource" need to be changed
// back to using the constants.
// See https://github.com/microsoft/TypeScript/issues/37888
//
// import {
//   AGENT_NAME,
//   SERVICE_ENVIRONMENT,
//   SERVICE_NAME,
//   SPAN_DESTINATION_SERVICE_RESOURCE,
//   SPAN_SUBTYPE,
//   SPAN_TYPE,
// } from './es_fields/apm';

const invalidLicenseMessage = _i18n.i18n.translate('xpack.apm.serviceMap.invalidLicenseMessage', {
  defaultMessage: "In order to access Service Maps, you must be subscribed to an Elastic Platinum license. With it, you'll have the ability to visualize your entire application stack along with your APM data."
});
exports.invalidLicenseMessage = invalidLicenseMessage;
const NONGROUPED_SPANS = {
  aws: ['servicename'],
  cache: ['all'],
  db: ['all'],
  external: ['graphql', 'grpc', 'websocket'],
  messaging: ['all'],
  template: ['handlebars']
};
function isSpanGroupingSupported(type, subtype) {
  if (!type || !(type in NONGROUPED_SPANS)) {
    return true;
  }
  return !NONGROUPED_SPANS[type].some(nongroupedSubType => nongroupedSubType === 'all' || nongroupedSubType === subtype);
}
const SERVICE_MAP_TIMEOUT_ERROR = 'ServiceMapTimeoutError';
exports.SERVICE_MAP_TIMEOUT_ERROR = SERVICE_MAP_TIMEOUT_ERROR;