"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleSavedObject = getRuleSavedObject;
var _apmUtils = require("@kbn/apm-utils");
var _audit_events = require("../common/audit_events");
var _rule = require("../../data/rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRuleSavedObject(context, params) {
  var _context$auditLogger;
  const {
    ruleId
  } = params;
  (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.GET,
    outcome: 'unknown',
    savedObject: {
      type: 'alert',
      id: ruleId
    }
  }));
  return await (0, _apmUtils.withSpan)({
    name: 'unsecuredSavedObjectsClient.get',
    type: 'rules'
  }, () => (0, _rule.getRuleSo)({
    id: ruleId,
    savedObjectsClient: context.unsecuredSavedObjectsClient
  }));
}