"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeRuleRoute = void 0;
var _snooze = require("../../../../../common/routes/rule/apis/snooze");
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _transforms = require("./transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const snoozeRuleRoute = (router, licenseState) => {
  router.post({
    path: _types.INTERNAL_ALERTING_SNOOZE_RULE,
    validate: {
      params: _snooze.snoozeParamsSchema,
      body: _snooze.snoozeBodySchema
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    const body = (0, _transforms.transformSnoozeBodyV1)(req.body);
    try {
      await rulesClient.snooze({
        ...params,
        ...body
      });
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleMutedError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.snoozeRuleRoute = snoozeRuleRoute;