"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.muteAlertRoute = void 0;
var _transforms = require("./transforms");
var _lib = require("../../../../lib");
var _lib2 = require("../../../lib");
var _types = require("../../../../types");
var _mute_alert = require("../../../../../common/routes/rule/apis/mute_alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const muteAlertRoute = (router, licenseState) => {
  router.post({
    path: `${_types.BASE_ALERTING_API_PATH}/rule/{rule_id}/alert/{alert_id}/_mute`,
    validate: {
      params: _mute_alert.muteAlertParamsSchemaV1
    }
  }, router.handleLegacyErrors((0, _lib2.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = (await context.alerting).getRulesClient();
    const params = req.params;
    try {
      await rulesClient.muteInstance((0, _transforms.transformRequestParamsToApplicationV1)(params));
      return res.noContent();
    } catch (e) {
      if (e instanceof _lib.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  })));
};
exports.muteAlertRoute = muteAlertRoute;