"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindowsRoute = void 0;
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMaintenanceWindowsRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/_find`,
    validate: {},
    options: {
      tags: [`access:${_common.MAINTENANCE_WINDOW_API_PRIVILEGES.READ_MAINTENANCE_WINDOW}`]
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    licenseState.ensureLicenseForMaintenanceWindow();
    const maintenanceWindowClient = (await context.alerting).getMaintenanceWindowClient();
    const result = await maintenanceWindowClient.find();
    const response = {
      body: {
        data: result.data.map(maintenanceWindow => (0, _transforms.transformMaintenanceWindowToResponseV1)(maintenanceWindow)),
        total: result.data.length
      }
    };
    return res.ok(response);
  })));
};
exports.findMaintenanceWindowsRoute = findMaintenanceWindowsRoute;