"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQuery = require("@kbn/es-query");
var _validate_timezone = require("./validate_timezone");
var _lib = require("../../lib");
var _validate_hours = require("./validate_hours");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionsSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  group: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  frequency: _configSchema.schema.maybe(_configSchema.schema.object({
    summary: _configSchema.schema.boolean(),
    notify_when: _configSchema.schema.oneOf([_configSchema.schema.literal('onActionGroupChange'), _configSchema.schema.literal('onActiveAlert'), _configSchema.schema.literal('onThrottleInterval')]),
    throttle: _configSchema.schema.nullable(_configSchema.schema.string({
      validate: _lib.validateDurationSchema
    }))
  })),
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  alerts_filter: _configSchema.schema.maybe(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.object({
      kql: _configSchema.schema.string(),
      filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
        query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
        meta: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
        $state: _configSchema.schema.maybe(_configSchema.schema.object({
          store: _configSchema.schema.oneOf([_configSchema.schema.literal(_esQuery.FilterStateStore.APP_STATE), _configSchema.schema.literal(_esQuery.FilterStateStore.GLOBAL_STATE)])
        }))
      })),
      dsl: _configSchema.schema.maybe(_configSchema.schema.string())
    })),
    timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
      days: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)])),
      hours: _configSchema.schema.object({
        start: _configSchema.schema.string({
          validate: _validate_hours.validateHours
        }),
        end: _configSchema.schema.string({
          validate: _validate_hours.validateHours
        })
      }),
      timezone: _configSchema.schema.string({
        validate: _validate_timezone.validateTimezone
      })
    }))
  })),
  use_alert_data_for_template: _configSchema.schema.maybe(_configSchema.schema.boolean())
}), {
  defaultValue: []
});
exports.actionsSchema = actionsSchema;