"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.snoozeScheduleSchema = exports.ruleSchema = exports.ruleParamsSchema = exports.ruleLastRunSchema = exports.ruleExecutionStatusSchema = exports.ruleDomainSchema = exports.monitoringSchema = exports.mappedParamsSchema = exports.intervalScheduleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("../../r_rule/schemas");
var _date_schema = require("./date_schema");
var _notify_when_schema = require("./notify_when_schema");
var _action_schemas = require("./action_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
exports.ruleParamsSchema = ruleParamsSchema;
const mappedParamsSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.any()));
exports.mappedParamsSchema = mappedParamsSchema;
const intervalScheduleSchema = _configSchema.schema.object({
  interval: _configSchema.schema.string()
});
exports.intervalScheduleSchema = intervalScheduleSchema;
const ruleExecutionStatusSchema = _configSchema.schema.object({
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ruleExecutionStatusValues.OK), _configSchema.schema.literal(_constants.ruleExecutionStatusValues.ACTIVE), _configSchema.schema.literal(_constants.ruleExecutionStatusValues.ERROR), _configSchema.schema.literal(_constants.ruleExecutionStatusValues.WARNING), _configSchema.schema.literal(_constants.ruleExecutionStatusValues.PENDING), _configSchema.schema.literal(_constants.ruleExecutionStatusValues.UNKNOWN)]),
  lastExecutionDate: _date_schema.dateSchema,
  lastDuration: _configSchema.schema.maybe(_configSchema.schema.number()),
  error: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.VALIDATE)]),
    message: _configSchema.schema.string()
  })),
  warning: _configSchema.schema.maybe(_configSchema.schema.object({
    reason: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS)]),
    message: _configSchema.schema.string()
  }))
});
exports.ruleExecutionStatusSchema = ruleExecutionStatusSchema;
const ruleLastRunSchema = _configSchema.schema.object({
  outcome: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ruleLastRunOutcomeValues.SUCCEEDED), _configSchema.schema.literal(_constants.ruleLastRunOutcomeValues.WARNING), _configSchema.schema.literal(_constants.ruleLastRunOutcomeValues.FAILED)]),
  outcomeOrder: _configSchema.schema.maybe(_configSchema.schema.number()),
  warning: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.READ), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.DECRYPT), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.EXECUTE), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.UNKNOWN), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.LICENSE), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.TIMEOUT), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.DISABLED), _configSchema.schema.literal(_constants.ruleExecutionStatusErrorReason.VALIDATE), _configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_EXECUTABLE_ACTIONS), _configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_ALERTS), _configSchema.schema.literal(_constants.ruleExecutionStatusWarningReason.MAX_QUEUED_ACTIONS)]))),
  outcomeMsg: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))),
  alertsCount: _configSchema.schema.object({
    active: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    new: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    recovered: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
    ignored: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
  })
});
exports.ruleLastRunSchema = ruleLastRunSchema;
const monitoringSchema = _configSchema.schema.object({
  run: _configSchema.schema.object({
    history: _configSchema.schema.arrayOf(_configSchema.schema.object({
      success: _configSchema.schema.boolean(),
      timestamp: _configSchema.schema.number(),
      duration: _configSchema.schema.maybe(_configSchema.schema.number()),
      outcome: _configSchema.schema.maybe(ruleLastRunSchema)
    })),
    calculated_metrics: _configSchema.schema.object({
      p50: _configSchema.schema.maybe(_configSchema.schema.number()),
      p95: _configSchema.schema.maybe(_configSchema.schema.number()),
      p99: _configSchema.schema.maybe(_configSchema.schema.number()),
      success_ratio: _configSchema.schema.number()
    }),
    last_run: _configSchema.schema.object({
      timestamp: _configSchema.schema.string(),
      metrics: _configSchema.schema.object({
        duration: _configSchema.schema.maybe(_configSchema.schema.number()),
        total_search_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_indexing_duration_ms: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_detected: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        total_alerts_created: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number())),
        gap_duration_s: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.number()))
      })
    })
  })
});
exports.monitoringSchema = monitoringSchema;
const snoozeScheduleSchema = _configSchema.schema.object({
  duration: _configSchema.schema.number(),
  rRule: _schemas.rRuleSchema,
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  skipRecurrences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});

/**
 * Unsanitized (domain) rule schema, used by internal rules clients
 */
exports.snoozeScheduleSchema = snoozeScheduleSchema;
const ruleDomainSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  alertTypeId: _configSchema.schema.string(),
  consumer: _configSchema.schema.string(),
  schedule: intervalScheduleSchema,
  actions: _configSchema.schema.arrayOf(_action_schemas.actionDomainSchema),
  params: ruleParamsSchema,
  mapped_params: _configSchema.schema.maybe(mappedParamsSchema),
  scheduledTaskId: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt: _date_schema.dateSchema,
  updatedAt: _date_schema.dateSchema,
  apiKey: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKeyOwner: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKeyCreatedByUser: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  muteAll: _configSchema.schema.boolean(),
  notifyWhen: _configSchema.schema.maybe(_configSchema.schema.nullable(_notify_when_schema.notifyWhenSchema)),
  mutedInstanceIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  executionStatus: ruleExecutionStatusSchema,
  monitoring: _configSchema.schema.maybe(monitoringSchema),
  snoozeSchedule: _configSchema.schema.maybe(_configSchema.schema.arrayOf(snoozeScheduleSchema)),
  activeSnoozes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  isSnoozedUntil: _configSchema.schema.maybe(_configSchema.schema.nullable(_date_schema.dateSchema)),
  lastRun: _configSchema.schema.maybe(_configSchema.schema.nullable(ruleLastRunSchema)),
  nextRun: _configSchema.schema.maybe(_configSchema.schema.nullable(_date_schema.dateSchema)),
  revision: _configSchema.schema.number(),
  running: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  viewInAppRelativeUrl: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
});

/**
 * Sanitized (non-domain) rule schema, returned by rules clients for other solutions
 */
exports.ruleDomainSchema = ruleDomainSchema;
const ruleSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  name: _configSchema.schema.string(),
  tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  alertTypeId: _configSchema.schema.string(),
  consumer: _configSchema.schema.string(),
  schedule: intervalScheduleSchema,
  actions: _configSchema.schema.arrayOf(_action_schemas.actionSchema),
  params: ruleParamsSchema,
  mapped_params: _configSchema.schema.maybe(mappedParamsSchema),
  scheduledTaskId: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt: _date_schema.dateSchema,
  updatedAt: _date_schema.dateSchema,
  apiKeyOwner: _configSchema.schema.nullable(_configSchema.schema.string()),
  apiKeyCreatedByUser: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  throttle: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  muteAll: _configSchema.schema.boolean(),
  notifyWhen: _configSchema.schema.maybe(_configSchema.schema.nullable(_notify_when_schema.notifyWhenSchema)),
  mutedInstanceIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  executionStatus: ruleExecutionStatusSchema,
  monitoring: _configSchema.schema.maybe(monitoringSchema),
  snoozeSchedule: _configSchema.schema.maybe(_configSchema.schema.arrayOf(snoozeScheduleSchema)),
  activeSnoozes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  isSnoozedUntil: _configSchema.schema.maybe(_configSchema.schema.nullable(_date_schema.dateSchema)),
  lastRun: _configSchema.schema.maybe(_configSchema.schema.nullable(ruleLastRunSchema)),
  nextRun: _configSchema.schema.maybe(_configSchema.schema.nullable(_date_schema.dateSchema)),
  revision: _configSchema.schema.number(),
  running: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
  viewInAppRelativeUrl: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
});
exports.ruleSchema = ruleSchema;