"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveRule = resolveRule;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _apmUtils = require("@kbn/apm-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lib = require("../../../../rules_client/lib");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _authorization = require("../../../../authorization");
var _transforms = require("../../transforms");
var _schemas = require("../../schemas");
var _schemas2 = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveRule(context, {
  id,
  includeSnoozeData = false
}) {
  var _context$auditLogger2;
  try {
    _schemas2.resolveRuleParamsSchema.validate({
      id
    });
  } catch (error) {
    throw _boom.default.badRequest(`Error validating resolve params - ${error.message}`);
  }
  const {
    saved_object: result,
    ...resolveResponse
  } = await (0, _apmUtils.withSpan)({
    name: 'resolveRuleSavedObject',
    type: 'rules'
  }, () => (0, _lib.resolveRuleSavedObject)(context, {
    ruleId: id
  }));
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: result.attributes.alertTypeId,
      consumer: result.attributes.consumer,
      operation: _authorization.ReadOperations.Get,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.RESOLVE,
      savedObject: {
        type: 'alert',
        id
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.RESOLVE,
    savedObject: {
      type: 'alert',
      id
    }
  }));
  const ruleDomain = (0, _transforms.transformRuleAttributesToRuleDomain)(result.attributes, {
    id: result.id,
    logger: context.logger,
    ruleType: context.ruleTypeRegistry.get(result.attributes.alertTypeId),
    references: result.references,
    includeSnoozeData
  });
  const rule = (0, _transforms.transformRuleDomainToRule)(ruleDomain);
  try {
    _schemas.ruleSchema.validate(rule);
  } catch (error) {
    context.logger.warn(`Error validating resolve data - ${error.message}`);
  }

  // format legacy actions for SIEM rules
  if (result.attributes.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
    // @ts-expect-error formatLegacyActions uses common Rule type instead of server; wontfix as this function is deprecated
    const [migratedRule] = await (0, _lib.formatLegacyActions)([rule], {
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      logger: context.logger
    });
    return {
      ...migratedRule,
      ...resolveResponse
      // TODO (http-versioning): Remove this cast, this enables us to move forward
      // without fixing all of other solution types
    };
  }

  return {
    ...rule,
    ...resolveResponse
    // TODO (http-versioning): Remove this cast, this enables us to move forward
    // without fixing all of other solution types
  };
}