"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleNotifyWhen = exports.ruleLastRunOutcomeValues = exports.ruleExecutionStatusWarningReason = exports.ruleExecutionStatusValues = exports.ruleExecutionStatusErrorReason = exports.filterStateStore = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleNotifyWhen = {
  CHANGE: 'onActionGroupChange',
  ACTIVE: 'onActiveAlert',
  THROTTLE: 'onThrottleInterval'
};
exports.ruleNotifyWhen = ruleNotifyWhen;
const ruleLastRunOutcomeValues = {
  SUCCEEDED: 'succeeded',
  WARNING: 'warning',
  FAILED: 'failed'
};
exports.ruleLastRunOutcomeValues = ruleLastRunOutcomeValues;
const ruleExecutionStatusValues = {
  OK: 'ok',
  ACTIVE: 'active',
  ERROR: 'error',
  WARNING: 'warning',
  PENDING: 'pending',
  UNKNOWN: 'unknown'
};
exports.ruleExecutionStatusValues = ruleExecutionStatusValues;
const ruleExecutionStatusErrorReason = {
  READ: 'read',
  DECRYPT: 'decrypt',
  EXECUTE: 'execute',
  UNKNOWN: 'unknown',
  LICENSE: 'license',
  TIMEOUT: 'timeout',
  DISABLED: 'disabled',
  VALIDATE: 'validate'
};
exports.ruleExecutionStatusErrorReason = ruleExecutionStatusErrorReason;
const ruleExecutionStatusWarningReason = {
  MAX_EXECUTABLE_ACTIONS: 'maxExecutableActions',
  MAX_ALERTS: 'maxAlerts',
  MAX_QUEUED_ACTIONS: 'maxQueuedActions'
};
exports.ruleExecutionStatusWarningReason = ruleExecutionStatusWarningReason;
const filterStateStore = {
  APP_STATE: 'appState',
  GLOBAL_STATE: 'globalState'
};
exports.filterStateStore = filterStateStore;