"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMaintenanceWindowToMaintenanceWindowAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMaintenanceWindowToMaintenanceWindowAttributes = maintenanceWindow => {
  return {
    title: maintenanceWindow.title,
    enabled: maintenanceWindow.enabled,
    duration: maintenanceWindow.duration,
    expirationDate: maintenanceWindow.expirationDate,
    events: maintenanceWindow.events,
    rRule: maintenanceWindow.rRule,
    createdBy: maintenanceWindow.createdBy,
    updatedBy: maintenanceWindow.updatedBy,
    createdAt: maintenanceWindow.createdAt,
    updatedAt: maintenanceWindow.updatedAt,
    ...(maintenanceWindow.categoryIds !== undefined ? {
      categoryIds: maintenanceWindow.categoryIds
    } : {}),
    ...(maintenanceWindow.scopedQuery !== undefined ? {
      scopedQuery: maintenanceWindow.scopedQuery
    } : {})
  };
};
exports.transformMaintenanceWindowToMaintenanceWindowAttributes = transformMaintenanceWindowToMaintenanceWindowAttributes;