"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.MaintenanceWindowsCreatePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _use_navigation = require("../../hooks/use_navigation");
var i18n = _interopRequireWildcard(require("./translations"));
var _page_header = require("./components/page_header");
var _create_maintenance_windows_form = require("./components/create_maintenance_windows_form");
var _common = require("../../../common");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaintenanceWindowsCreatePage = /*#__PURE__*/_react.default.memo(() => {
  (0, _use_breadcrumbs.useBreadcrumbs)(_common.MAINTENANCE_WINDOW_DEEP_LINK_IDS.maintenanceWindowsCreate);
  const {
    navigateToMaintenanceWindows
  } = (0, _use_navigation.useMaintenanceWindowsNavigation)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, {
    showBackButton: true,
    title: i18n.CREATE_MAINTENANCE_WINDOW,
    description: i18n.CREATE_MAINTENANCE_WINDOW_DESCRIPTION
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_create_maintenance_windows_form.CreateMaintenanceWindowForm, {
    onCancel: navigateToMaintenanceWindows,
    onSuccess: navigateToMaintenanceWindows,
    scopedQueryFeatureFlag: _constants.IS_SCOPED_QUERY_ENABLED
  }));
});
exports.default = exports.MaintenanceWindowsCreatePage = MaintenanceWindowsCreatePage;
MaintenanceWindowsCreatePage.displayName = 'MaintenanceWindowsCreatePage';
// eslint-disable-next-line import/no-default-export