"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActionsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableActionsPopover = /*#__PURE__*/_react.default.memo(({
  id,
  status,
  onEdit,
  onCancel,
  onArchive,
  onCancelAndArchive
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [modalType, setModalType] = (0, _react.useState)();
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(type => {
    setModalType(type);
    setIsModalVisible(true);
  }, []);
  const modal = (0, _react.useMemo)(() => {
    const modals = {
      cancel: {
        props: {
          title: i18n.CANCEL_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onCancel(id);
          },
          cancelButtonText: i18n.CANCEL_MODAL_BUTTON,
          confirmButtonText: i18n.CANCEL_MODAL_TITLE
        },
        subtitle: i18n.CANCEL_MODAL_SUBTITLE
      },
      cancelAndArchive: {
        props: {
          title: i18n.CANCEL_AND_ARCHIVE_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onCancelAndArchive(id);
          },
          cancelButtonText: i18n.CANCEL_MODAL_BUTTON,
          confirmButtonText: i18n.CANCEL_AND_ARCHIVE_MODAL_TITLE
        },
        subtitle: i18n.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE
      },
      archive: {
        props: {
          title: i18n.ARCHIVE_TITLE,
          onConfirm: () => {
            closeModal();
            onArchive(id, true);
          },
          cancelButtonText: i18n.CANCEL,
          confirmButtonText: i18n.ARCHIVE_TITLE
        },
        subtitle: i18n.ARCHIVE_SUBTITLE
      },
      unarchive: {
        props: {
          title: i18n.UNARCHIVE_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onArchive(id, false);
          },
          cancelButtonText: i18n.CANCEL,
          confirmButtonText: i18n.UNARCHIVE_MODAL_TITLE
        },
        subtitle: i18n.UNARCHIVE_MODAL_SUBTITLE
      }
    };
    let m;
    if (isModalVisible && modalType) {
      const modalProps = modals[modalType];
      m = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({}, modalProps.props, {
        style: {
          width: 600
        },
        onCancel: closeModal,
        defaultFocusedButton: "confirm",
        buttonColor: "danger"
      }), /*#__PURE__*/_react.default.createElement("p", null, modalProps.subtitle));
    }
    return m;
  }, [id, modalType, isModalVisible, closeModal, onArchive, onCancel, onCancelAndArchive]);
  const items = (0, _react.useMemo)(() => {
    const menuItems = {
      edit: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-edit",
        key: "edit",
        icon: "pencil",
        onClick: () => {
          closePopover();
          onEdit(id);
        }
      }, i18n.TABLE_ACTION_EDIT),
      cancel: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-cancel",
        key: "cancel",
        icon: "stopSlash",
        onClick: () => {
          closePopover();
          showModal('cancel');
        }
      }, i18n.TABLE_ACTION_CANCEL),
      cancelAndArchive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-cancel-and-archive",
        key: "cancel-and-archive",
        icon: "trash",
        onClick: () => {
          closePopover();
          showModal('cancelAndArchive');
        }
      }, i18n.TABLE_ACTION_CANCEL_AND_ARCHIVE),
      archive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-archive",
        key: "archive",
        icon: "trash",
        onClick: () => {
          closePopover();
          showModal('archive');
        }
      }, i18n.ARCHIVE),
      unarchive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-unarchive",
        key: "unarchive",
        icon: "exit",
        onClick: () => {
          closePopover();
          showModal('unarchive');
        }
      }, i18n.TABLE_ACTION_UNARCHIVE)
    };
    const statusMenuItemsMap = {
      running: ['edit', 'cancel', 'cancelAndArchive'],
      upcoming: ['edit', 'archive'],
      finished: ['edit', 'archive'],
      archived: ['unarchive']
    };
    return statusMenuItemsMap[status].map(type => menuItems[type]);
  }, [id, status, onEdit, closePopover, showModal]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "table-actions-icon-button",
    iconType: "boxesHorizontal",
    size: "s",
    "aria-label": "Upcoming events",
    onClick: onButtonClick
  }), [onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    "data-test-subj": "table-actions-popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })))), modal);
});
exports.TableActionsPopover = TableActionsPopover;
TableActionsPopover.displayName = 'TableActionsPopover';