"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetRuleTypes = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../utils/kibana_react");
var _alert_api = require("../services/alert_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetRuleTypes = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryFn = () => {
    return (0, _alert_api.loadRuleTypes)({
      http
    });
  };
  const onError = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.alerting.hooks.useGetRuleTypes.error', {
      defaultMessage: 'Unable to load rule types.'
    }));
  };
  const {
    isLoading,
    isFetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['useGetRuleTypes'],
    queryFn,
    onError,
    refetchOnWindowFocus: false
  });
  return {
    data,
    isLoading: isLoading || isFetching
  };
};
exports.useGetRuleTypes = useGetRuleTypes;