"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactQuery = require("@tanstack/react-query");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _eui = require("@elastic/eui");
var _common2 = require("../../common");
var _use_license = require("../hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const MaintenanceWindowsLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows'))));
const MaintenanceWindowsCreateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows/maintenance_window_create_page'))));
const MaintenanceWindowsEditLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows/maintenance_window_edit_page'))));
const App = /*#__PURE__*/_react.default.memo(() => {
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicense = isAtLeastPlatinum();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, hasLicense ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: _common2.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsCreate,
    path: _common2.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsCreate,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsCreateLazy, null))) : null, hasLicense ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: _common2.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsEdit,
    path: _common2.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsEdit,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsEditLazy, null))) : null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsLazy, null))));
});
App.displayName = 'App';
const renderApp = ({
  core,
  plugins,
  mountParams,
  kibanaVersion
}) => {
  const {
    element,
    history,
    theme$
  } = mountParams;
  const i18nCore = core.i18n;
  const isDarkMode = core.uiSettings.get('theme:darkMode');
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public2.Storage(localStorage),
      kibanaVersion
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(App, null))))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;