"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleIdsSchema = exports.ruleSnoozeScheduleSchema = exports.bulkEditRulesRequestBodySchema = exports.bulkEditOperationsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _validation = require("../../../validation");
var _r_rule = require("../../../../r_rule");
var _response = require("../../../response");
var _request = require("../../../request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduleIdsSchema = _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()));
exports.scheduleIdsSchema = scheduleIdsSchema;
const ruleSnoozeScheduleSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  duration: _configSchema.schema.number(),
  rRule: _r_rule.rRuleRequestSchemaV1
});
exports.ruleSnoozeScheduleSchema = ruleSnoozeScheduleSchema;
const ruleActionSchema = _configSchema.schema.object({
  group: _configSchema.schema.string(),
  id: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
    defaultValue: {}
  }),
  uuid: _configSchema.schema.maybe(_configSchema.schema.string()),
  frequency: _configSchema.schema.maybe(_configSchema.schema.object({
    summary: _configSchema.schema.boolean(),
    throttle: _configSchema.schema.nullable(_configSchema.schema.string()),
    notifyWhen: _response.notifyWhenSchemaV1
  }))
});
const bulkEditOperationsSchema = _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('add'), _configSchema.schema.literal('delete'), _configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('tags'),
  value: _configSchema.schema.arrayOf(_configSchema.schema.string())
}), _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('add'), _configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('actions'),
  value: _configSchema.schema.arrayOf(ruleActionSchema)
}), _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('schedule'),
  value: _configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: _validation.validateDurationV1
    })
  })
}), _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('throttle'),
  value: _configSchema.schema.nullable(_configSchema.schema.string())
}), _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('notifyWhen'),
  value: _response.notifyWhenSchemaV1
}), _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('set')]),
  field: _configSchema.schema.literal('snoozeSchedule'),
  value: _request.ruleSnoozeScheduleSchemaV1
}), _configSchema.schema.object({
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('delete')]),
  field: _configSchema.schema.literal('snoozeSchedule'),
  value: _configSchema.schema.maybe(_response.scheduleIdsSchemaV1)
}), _configSchema.schema.object({
  operation: _configSchema.schema.literal('set'),
  field: _configSchema.schema.literal('apiKey')
})]), {
  minSize: 1
});
exports.bulkEditOperationsSchema = bulkEditOperationsSchema;
const bulkEditRulesRequestBodySchema = _configSchema.schema.object({
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1
  })),
  operations: bulkEditOperationsSchema
});
exports.bulkEditRulesRequestBodySchema = bulkEditRulesRequestBodySchema;