"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTermsQuery = exports.getQueryWithParams = void 0;
var _get_range_query = require("./get_range_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTermsQuery = ({
  fieldName,
  fieldValue
}) => {
  return {
    term: {
      [fieldName]: fieldValue
    }
  };
};
exports.getTermsQuery = getTermsQuery;
const getQueryWithParams = ({
  params,
  termFilters,
  filter,
  skipRangeQuery = false
}) => {
  const searchQuery = JSON.parse(params.searchQuery);
  return {
    bool: {
      filter: [
      // Add `searchQuery` if it's not a `match_all` query
      ...(searchQuery.match_all === undefined ? [searchQuery] : []),
      // Add a range query based on `start/end` for the `timeFieldName`, check for skip flag.
      ...(!skipRangeQuery ? [(0, _get_range_query.getRangeQuery)(params.start, params.end, params.timeFieldName)] : []),
      // Add optional term filters
      ...(Array.isArray(termFilters) ? termFilters.map(getTermsQuery) : []),
      // Add other optional filters
      ...(filter ? [filter] : [])]
    }
  };
};
exports.getQueryWithParams = getQueryWithParams;