"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAiopsUiActions = registerAiopsUiActions;
var _public = require("@kbn/embeddable-plugin/public");
var _ui_actions = require("@kbn/ml-ui-actions/src/aiops/ui_actions");
var _edit_change_point_charts_panel = require("./edit_change_point_charts_panel");
var _log_categorization = require("../components/log_categorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerAiopsUiActions(uiActions, coreStart, pluginStart) {
  // Initialize actions
  const editChangePointChartPanelAction = (0, _edit_change_point_charts_panel.createEditChangePointChartsPanelAction)(coreStart, pluginStart);
  // // Register actions and triggers
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, editChangePointChartPanelAction);
  uiActions.registerTrigger(_ui_actions.categorizeFieldTrigger);
  uiActions.addTriggerAction(_ui_actions.CATEGORIZE_FIELD_TRIGGER, (0, _log_categorization.createCategorizeFieldAction)(coreStart, pluginStart));
}