"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCategorizationJobButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _mlUiActions = require("@kbn/ml-ui-actions");
var _i18nReact = require("@kbn/i18n-react");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateCategorizationJobButton = ({
  dataView,
  field,
  query,
  earliest,
  latest
}) => {
  const {
    uiActions,
    application: {
      capabilities
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const createADJob = () => {
    if (uiActions === undefined) {
      return;
    }
    const triggerOptions = {
      dataView,
      field,
      query,
      timeRange: {
        from: (0, _moment.default)(earliest).toISOString(),
        to: (0, _moment.default)(latest).toISOString()
      }
    };
    uiActions.getTrigger(_mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_TRIGGER).exec(triggerOptions);
  };
  if (uiActions === undefined || capabilities.ml.canCreateJob === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "aiopsLogCategorizationFlyoutAdJobButton",
    onClick: createADJob,
    flush: "left",
    iconSide: "left",
    iconType: 'machineLearningApp'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.categorizeFlyout.findAnomalies",
    defaultMessage: "Find anomalies in patterns"
  })));
};
exports.CreateCategorizationJobButton = CreateCategorizationJobButton;