"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointDetectionAppState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _operators = require("rxjs/operators");
var _lodash = require("lodash");
var _common = require("@kbn/kibana-react-plugin/common");
var _eui = require("@elastic/eui");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common2 = require("@kbn/data-plugin/common");
var _use_data_source = require("../../hooks/use_data_source");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _storage = require("../../types/storage");
var _page_header = require("../page_header");
var _change_point_detection_page = require("./change_point_detection_page");
var _change_point_detection_context = require("./change_point_detection_context");
var _time_series_dataview_check = require("../../application/utils/time_series_dataview_check");
var _use_reload = require("../../hooks/use_reload");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the ChangePointDetectionAppState component.
 */

const ChangePointDetectionAppState = ({
  dataView,
  savedSearch,
  appDependencies,
  showFrozenDataTierChoice = true
}) => {
  var _appDependencies$pres, _appDependencies$pres2, _appDependencies$case, _appDependencies$case2, _appDependencies$case3;
  const datePickerDeps = {
    ...(0, _lodash.pick)(appDependencies, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common2.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'change_point_detection');
  const reload$ = (0, _react.useMemo)(() => {
    return _mlDatePicker.mlTimefilterRefresh$.pipe((0, _operators.map)(v => v.lastRefresh));
  }, []);
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  appDependencies.embeddingOrigin = _constants.AIOPS_TELEMETRY_ID.AIOPS_DEFAULT_SOURCE;
  const PresentationContextProvider = (_appDependencies$pres = (_appDependencies$pres2 = appDependencies.presentationUtil) === null || _appDependencies$pres2 === void 0 ? void 0 : _appDependencies$pres2.ContextProvider) !== null && _appDependencies$pres !== void 0 ? _appDependencies$pres : _react.default.Fragment;
  const CasesContext = (_appDependencies$case = (_appDependencies$case2 = appDependencies.cases) === null || _appDependencies$case2 === void 0 ? void 0 : _appDependencies$case2.ui.getCasesContext()) !== null && _appDependencies$case !== void 0 ? _appDependencies$case : _react.default.Fragment;
  const casesPermissions = (_appDependencies$case3 = appDependencies.cases) === null || _appDependencies$case3 === void 0 ? void 0 : _appDependencies$case3.helpers.canUseCases();
  return /*#__PURE__*/_react.default.createElement(PresentationContextProvider, null, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions
  }, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appDependencies
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_page_header.PageHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: reload$
  }, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, null, /*#__PURE__*/_react.default.createElement(_change_point_detection_page.ChangePointDetectionPage, null))))))))))));
};
exports.ChangePointDetectionAppState = ChangePointDetectionAppState;