"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialState = void 0;
exports.streamReducer = streamReducer;
var _actions = require("./log_rate_analysis/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  ccsWarning: false,
  significantItems: [],
  significantItemsGroups: [],
  errors: [],
  loaded: 0,
  loadingState: '',
  zeroDocsFallback: false
};
exports.initialState = initialState;
function streamReducer(state, action) {
  if (Array.isArray(action)) {
    return action.reduce(streamReducer, state);
  }
  switch (action.type) {
    case _actions.API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS:
      return {
        ...state,
        significantItems: [...state.significantItems, ...action.payload]
      };
    case _actions.API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_HISTOGRAM:
      const significantItems = state.significantItems.map(cp => {
        const cpHistogram = action.payload.find(h => h.fieldName === cp.fieldName && h.fieldValue === cp.fieldValue);
        if (cpHistogram) {
          cp.histogram = cpHistogram.histogram;
        }
        return cp;
      });
      return {
        ...state,
        significantItems
      };
    case _actions.API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_GROUP:
      return {
        ...state,
        significantItemsGroups: action.payload
      };
    case _actions.API_ACTION_NAME.ADD_SIGNIFICANT_ITEMS_GROUP_HISTOGRAM:
      const significantItemsGroups = state.significantItemsGroups.map(cpg => {
        const cpHistogram = action.payload.find(h => h.id === cpg.id);
        if (cpHistogram) {
          cpg.histogram = cpHistogram.histogram;
        }
        return cpg;
      });
      return {
        ...state,
        significantItemsGroups
      };
    case _actions.API_ACTION_NAME.ADD_ERROR:
      return {
        ...state,
        errors: [...state.errors, action.payload]
      };
    case _actions.API_ACTION_NAME.RESET_ERRORS:
      return {
        ...state,
        errors: []
      };
    case _actions.API_ACTION_NAME.RESET_GROUPS:
      return {
        ...state,
        significantItemsGroups: []
      };
    case _actions.API_ACTION_NAME.RESET_ALL:
      return initialState;
    case _actions.API_ACTION_NAME.UPDATE_LOADING_STATE:
      return {
        ...state,
        ...action.payload
      };
    case _actions.API_ACTION_NAME.SET_ZERO_DOCS_FALLBACK:
      return {
        ...state,
        zeroDocsFallback: action.payload
      };
    default:
      return state;
  }
}