"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aiopsLogRateAnalysisSchemaV2 = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const significantItem = _configSchema.schema.object({
  key: _configSchema.schema.string(),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('keyword'), _configSchema.schema.literal('log_pattern')]),
  fieldName: _configSchema.schema.string(),
  fieldValue: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()]),
  doc_count: _configSchema.schema.number(),
  bg_count: _configSchema.schema.number(),
  total_doc_count: _configSchema.schema.number(),
  total_bg_count: _configSchema.schema.number(),
  score: _configSchema.schema.number(),
  pValue: _configSchema.schema.nullable(_configSchema.schema.number()),
  normalizedScore: _configSchema.schema.number(),
  histogram: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    doc_count_overall: _configSchema.schema.number(),
    doc_count_significant_item: _configSchema.schema.number(),
    key: _configSchema.schema.number(),
    key_as_string: _configSchema.schema.string()
  }))),
  unique: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const aiopsLogRateAnalysisSchemaV2 = _configSchema.schema.object({
  start: _configSchema.schema.number(),
  end: _configSchema.schema.number(),
  searchQuery: _configSchema.schema.string(),
  timeFieldName: _configSchema.schema.string(),
  includeFrozen: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  grouping: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  /** Analysis selection time ranges */
  baselineMin: _configSchema.schema.number(),
  baselineMax: _configSchema.schema.number(),
  deviationMin: _configSchema.schema.number(),
  deviationMax: _configSchema.schema.number(),
  /** The index to query for log rate analysis */
  index: _configSchema.schema.string(),
  /** Settings to override headers derived compression and flush fix */
  compressResponse: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  flushFix: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  /** Overrides to skip steps of the analysis with existing data */
  overrides: _configSchema.schema.maybe(_configSchema.schema.object({
    loaded: _configSchema.schema.maybe(_configSchema.schema.number()),
    remainingFieldCandidates: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    significantItems: _configSchema.schema.maybe(_configSchema.schema.arrayOf(significantItem)),
    regroupOnly: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })),
  /** Probability used for the random sampler aggregations */
  sampleProbability: _configSchema.schema.maybe(_configSchema.schema.number())
});
exports.aiopsLogRateAnalysisSchemaV2 = aiopsLogRateAnalysisSchemaV2;