"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategoryQuery = exports.QUERY_MODE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_MODE = {
  INCLUDE: 'should',
  EXCLUDE: 'must_not'
};
exports.QUERY_MODE = QUERY_MODE;
const getCategoryQuery = (field, categories, mode = QUERY_MODE.INCLUDE) => ({
  bool: {
    [mode]: categories.map(({
      key: query
    }) => ({
      match: {
        [field]: {
          auto_generate_synonyms_phrase_query: false,
          fuzziness: 0,
          operator: 'and',
          query
        }
      }
    }))
  }
});
exports.getCategoryQuery = getCategoryQuery;