"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = void 0;
exports.SettingsTab = SettingsTab;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_app_context = require("../../hooks/use_app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = 'xpack.observabilityAiAssistant.lastUsedConnector';
exports.SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = SELECTED_CONNECTOR_LOCAL_STORAGE_KEY;
function SettingsTab() {
  const {
    application: {
      navigateToApp
    },
    observabilityAIAssistant
  } = (0, _use_app_context.useAppContext)();
  const {
    connectors = [],
    selectedConnector,
    selectConnector
  } = observabilityAIAssistant.useGenAIConnectors();
  const selectorOptions = connectors.map(connector => ({
    text: connector.name,
    value: connector.id
  }));
  const handleNavigateToConnectors = () => {
    navigateToApp('management', {
      path: '/insightsAndAlerting/triggersActionsConnectors/connectors'
    });
  };
  const handleNavigateToSpacesConfiguration = () => {
    navigateToApp('management', {
      path: '/kibana/spaces'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.showAIAssistantButtonLabel', {
      defaultMessage: 'Show AI Assistant button and Contextual Insights in Observability apps'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.showAIAssistantDescriptionLabel', {
      defaultMessage: 'Toggle the AI Assistant button and Contextual Insights on or off in Observability apps by checking or unchecking the AI Assistant feature in Spaces > <your space> > Features.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "settingsTabGoToSpacesButton",
    onClick: handleNavigateToSpacesConfiguration
  }, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.goToFeatureControlsButtonLabel', {
    defaultMessage: 'Go to Spaces'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.connectorSettingsLabel', {
      defaultMessage: 'Connector settings'
    })),
    description: _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.euiDescribedFormGroup.inOrderToUseLabel', {
      defaultMessage: 'In order to use the Observability AI Assistant you must set up a Generative AI connector.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      textAlign: 'right'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "settingsTabGoToConnectorsButton",
    onClick: handleNavigateToConnectors
  }, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.goToConnectorsButtonLabel', {
    defaultMessage: 'Manage connectors'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.h4.selectDefaultConnectorLabel', {
      defaultMessage: 'Default connector'
    })),
    description: _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.connectYourElasticAITextLabel', {
      defaultMessage: 'Select the Generative AI connector you want to use as the default for the Observability AI Assistant.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.selectConnectorLabel', {
      defaultMessage: 'Select connector'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "settingsTabGenAIConnectorSelect",
    id: "generativeAIProvider",
    options: selectorOptions,
    value: selectedConnector,
    onChange: e => {
      selectConnector(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('aiAssistantManagementObservability.settingsPage.euiSelect.generativeAIProviderLabel', {
      defaultMessage: 'Generative AI provider'
    })
  }))))));
}