"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseEditManualEntryFlyout = KnowledgeBaseEditManualEntryFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _use_create_knowledge_base_entry = require("../../hooks/use_create_knowledge_base_entry");
var _use_delete_knowledge_base_entry = require("../../hooks/use_delete_knowledge_base_entry");
var _use_app_context = require("../../hooks/use_app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function KnowledgeBaseEditManualEntryFlyout({
  entry,
  onClose
}) {
  var _entry$id, _entry$text;
  const {
    uiSettings
  } = (0, _use_app_context.useAppContext)();
  const dateFormat = uiSettings.get('dateFormat');
  const {
    mutateAsync: createEntry,
    isLoading
  } = (0, _use_create_knowledge_base_entry.useCreateKnowledgeBaseEntry)();
  const {
    mutateAsync: deleteEntry,
    isLoading: isDeleting
  } = (0, _use_delete_knowledge_base_entry.useDeleteKnowledgeBaseEntry)();
  const [newEntryId, setNewEntryId] = (0, _react.useState)((_entry$id = entry === null || entry === void 0 ? void 0 : entry.id) !== null && _entry$id !== void 0 ? _entry$id : '');
  const [newEntryText, setNewEntryText] = (0, _react.useState)((_entry$text = entry === null || entry === void 0 ? void 0 : entry.text) !== null && _entry$text !== void 0 ? _entry$text : '');
  const handleSubmitNewEntryClick = async () => {
    createEntry({
      entry: {
        id: newEntryId,
        text: newEntryText
      }
    }).then(onClose);
  };
  const handleDelete = async () => {
    await deleteEntry({
      id: entry.id
    });
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "knowledgeBaseManualEntryFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, !entry ? _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseNewEntryFlyout.h2.newEntryLabel', {
    defaultMessage: 'New entry'
  }) : _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseNewEntryFlyout.h2.editEntryLabel', {
    defaultMessage: 'Edit {id}',
    values: {
      id: entry.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, !entry ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseEditManualEntryFlyout.euiFormRow.idLabel', {
      defaultMessage: 'Name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutFieldText",
    fullWidth: true,
    value: newEntryId,
    onChange: e => setNewEntryId(e.target.value)
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseEditManualEntryFlyout.createdOnTextLabel', {
    defaultMessage: 'Created on'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (0, _moment.default)(entry['@timestamp']).format(dateFormat))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutDeleteEntryButton",
    color: "danger",
    iconType: "trash",
    isLoading: isDeleting,
    onClick: handleDelete
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseEditManualEntryFlyout.deleteEntryButtonLabel', {
    defaultMessage: 'Delete entry'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseEditManualEntryFlyout.euiFormRow.contentsLabel', {
      defaultMessage: 'Contents'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    "aria-label": _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseNewManualEntryFlyout.euiMarkdownEditor.observabilityAiAssistantKnowledgeBaseViewMarkdownEditorLabel', {
      defaultMessage: 'observabilityAiAssistantKnowledgeBaseViewMarkdownEditor'
    }),
    height: 300,
    initialViewMode: "editing",
    readOnly: false,
    placeholder: _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseEditManualEntryFlyout.euiMarkdownEditor.enterContentsLabel', {
      defaultMessage: 'Enter contents'
    }),
    value: newEntryText,
    onChange: text => setNewEntryText(text)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutCancelButton",
    disabled: isLoading,
    onClick: onClose
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseNewManualEntryFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutSaveButton",
    fill: true,
    isLoading: isLoading,
    onClick: handleSubmitNewEntryClick
  }, _i18n.i18n.translate('aiAssistantManagementObservability.knowledgeBaseNewManualEntryFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}