"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.coreStart = void 0;
var _react = _interopRequireDefault(require("react"));
var _history = require("history");
var _reactQuery = require("@tanstack/react-query");
var _react2 = require("@testing-library/react");
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
var _jaJP = _interopRequireDefault(require("@kbn/translations-plugin/translations/ja-JP.json"));
var _mock = require("@kbn/observability-ai-assistant-plugin/public/mock");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _app_context = require("../context/app_context");
var _redirect_to_home_if_unauthorized = require("../routes/components/redirect_to_home_if_unauthorized");
var _config = require("../routes/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const coreStart = _mocks.coreMock.createStart();
exports.coreStart = coreStart;
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  logger: {
    // eslint-disable-next-line no-console
    log: console.log,
    // eslint-disable-next-line no-console
    warn: console.warn,
    error: () => {}
  }
});
const render = (component, params) => {
  var _params$show;
  const history = (0, _history.createMemoryHistory)();
  return (0, _react2.render)(
  /*#__PURE__*/
  // @ts-ignore
  _react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en-US",
    messages: _jaJP.default.messages
  }, /*#__PURE__*/_react.default.createElement(_redirect_to_home_if_unauthorized.RedirectToHomeIfUnauthorized, {
    coreStart: {
      application: {
        ...coreStart.application,
        capabilities: {
          // @ts-ignore
          management: {
            show: true
          },
          observabilityAIAssistant: {
            show: (_params$show = params === null || params === void 0 ? void 0 : params.show) !== null && _params$show !== void 0 ? _params$show : true
          }
        }
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      http: coreStart.http,
      application: coreStart.application,
      notifications: coreStart.notifications,
      observabilityAIAssistant: _mock.observabilityAIAssistantPluginMock.createStartContract(),
      uiSettings: coreStart.uiSettings,
      setBreadcrumbs: () => {}
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.aIAssistantManagementObservabilityRouter
  }, component))))));
};
exports.render = render;