"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listTypesRoute = void 0;
var _connector_types = require("../../../../common/routes/connector/apis/connector_types");
var _transforms = require("./transforms");
var _common = require("../../../../common");
var _verify_access_and_context = require("../../verify_access_and_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listTypesRoute = (router, licenseState) => {
  router.get({
    path: `${_common.BASE_ACTION_API_PATH}/connector_types`,
    validate: {
      query: _connector_types.connectorTypesQuerySchemaV1
    }
  }, router.handleLegacyErrors((0, _verify_access_and_context.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const actionsClient = (await context.actions).getActionsClient();

    // Assert versioned inputs
    const query = req.query;
    const connectorTypes = await actionsClient.listTypes({
      featureId: query === null || query === void 0 ? void 0 : query.feature_id
    });
    const responseBody = (0, _transforms.transformListTypesResponseV1)(connectorTypes);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.listTypesRoute = listTypesRoute;