"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthorizationMode = void 0;
exports.bulkGetAuthorizationModeBySource = bulkGetAuthorizationModeBySource;
exports.getAuthorizationModeBySource = getAuthorizationModeBySource;
var _lib = require("../lib");
var _saved_objects = require("../constants/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEGACY_VERSION = 'pre-7.10.0';
let AuthorizationMode;
exports.AuthorizationMode = AuthorizationMode;
(function (AuthorizationMode) {
  AuthorizationMode[AuthorizationMode["Legacy"] = 0] = "Legacy";
  AuthorizationMode[AuthorizationMode["RBAC"] = 1] = "RBAC";
})(AuthorizationMode || (exports.AuthorizationMode = AuthorizationMode = {}));
async function getAuthorizationModeBySource(unsecuredSavedObjectsClient, executionSource) {
  var _executionSource$sour, _await$unsecuredSaved;
  return (0, _lib.isSavedObjectExecutionSource)(executionSource) && (executionSource === null || executionSource === void 0 ? void 0 : (_executionSource$sour = executionSource.source) === null || _executionSource$sour === void 0 ? void 0 : _executionSource$sour.type) === _saved_objects.ALERT_SAVED_OBJECT_TYPE && ((_await$unsecuredSaved = (await unsecuredSavedObjectsClient.get(_saved_objects.ALERT_SAVED_OBJECT_TYPE, executionSource.source.id)).attributes.meta) === null || _await$unsecuredSaved === void 0 ? void 0 : _await$unsecuredSaved.versionApiKeyLastmodified) === LEGACY_VERSION ? AuthorizationMode.Legacy : AuthorizationMode.RBAC;
}
async function bulkGetAuthorizationModeBySource(logger, unsecuredSavedObjectsClient, executionSources = []) {
  const authModes = {
    [AuthorizationMode.Legacy]: 0,
    [AuthorizationMode.RBAC]: 0
  };
  const alertSavedObjectExecutionSources = executionSources.filter(source => {
    var _source$source;
    return (0, _lib.isSavedObjectExecutionSource)(source) && (source === null || source === void 0 ? void 0 : (_source$source = source.source) === null || _source$source === void 0 ? void 0 : _source$source.type) === _saved_objects.ALERT_SAVED_OBJECT_TYPE;
  });

  // If no ALERT_SAVED_OBJECT_TYPE source, default to RBAC
  if (alertSavedObjectExecutionSources.length === 0) {
    authModes[AuthorizationMode.RBAC] = 1;
    return authModes;
  }

  // Collect the unique rule IDs for ALERT_SAVED_OBJECT_TYPE sources and bulk get the associated SOs
  const rulesIds = new Set(alertSavedObjectExecutionSources.map(source => {
    var _source$source2;
    return source === null || source === void 0 ? void 0 : (_source$source2 = source.source) === null || _source$source2 === void 0 ? void 0 : _source$source2.id;
  }));

  // Get rule saved objects to determine whether to use RBAC or legacy authorization source
  const ruleSOs = await unsecuredSavedObjectsClient.bulkGet([...rulesIds].map(id => ({
    type: _saved_objects.ALERT_SAVED_OBJECT_TYPE,
    id
  })));
  return ruleSOs.saved_objects.reduce((acc, ruleSO) => {
    if (ruleSO.error) {
      var _ruleSO$error;
      logger.warn(`Error retrieving saved object [${ruleSO.type}/${ruleSO.id}] - ${(_ruleSO$error = ruleSO.error) === null || _ruleSO$error === void 0 ? void 0 : _ruleSO$error.message} - default to using RBAC authorization mode.`);
      // If there's an error retrieving the saved object, default to RBAC auth mode to avoid privilege de-escalation
      authModes[AuthorizationMode.RBAC]++;
    } else {
      var _ruleSO$attributes, _ruleSO$attributes$me;
      // Check whether this is a legacy rule
      const isLegacy = ((_ruleSO$attributes = ruleSO.attributes) === null || _ruleSO$attributes === void 0 ? void 0 : (_ruleSO$attributes$me = _ruleSO$attributes.meta) === null || _ruleSO$attributes$me === void 0 ? void 0 : _ruleSO$attributes$me.versionApiKeyLastmodified) === LEGACY_VERSION;
      if (isLegacy) {
        authModes[AuthorizationMode.Legacy]++;
      } else {
        authModes[AuthorizationMode.RBAC]++;
      }
    }
    return acc;
  }, authModes);
}