"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorTypeSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorTypeSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  name: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  enabledInConfig: _configSchema.schema.boolean(),
  enabledInLicense: _configSchema.schema.boolean(),
  minimumLicenseRequired: _configSchema.schema.oneOf([_configSchema.schema.literal('basic'), _configSchema.schema.literal('standard'), _configSchema.schema.literal('gold'), _configSchema.schema.literal('platinum'), _configSchema.schema.literal('enterprise'), _configSchema.schema.literal('trial')]),
  supportedFeatureIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  isSystemActionType: _configSchema.schema.boolean()
});
exports.connectorTypeSchema = connectorTypeSchema;