"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEuiTheme = exports.useEuiThemeCSSVariables = exports.useEuiTheme = exports.RenderWithEuiTheme = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("./context");
var _warning = require("./warning");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); } /*
                                                                                                                                                                                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                     */
var providerMessage = "`EuiProvider` is missing which can result in negative effects.\nWrap your component in `EuiProvider`: https://ela.st/euiprovider.";

/**
 * Hook for function components
 */

var useEuiTheme = function useEuiTheme() {
  var theme = (0, _react.useContext)(_context.EuiThemeContext);
  var colorMode = (0, _react.useContext)(_context.EuiColorModeContext);
  var modifications = (0, _react.useContext)(_context.EuiModificationsContext);
  var isFallback = theme === _context.defaultComputedTheme;
  if (isFallback) {
    (0, _warning.emitEuiProviderWarning)(providerMessage);
  }
  var assembledTheme = (0, _react.useMemo)(function () {
    return {
      euiTheme: theme,
      colorMode: colorMode,
      modifications: modifications
    };
  }, [theme, colorMode, modifications]);
  return assembledTheme;
};

/**
 * HOC for class components
 */
exports.useEuiTheme = useEuiTheme;
// Provide the component props interface as the generic to allow the docs props table to populate.
// e.g., `const EuiComponent = withEuiTheme<EuiComponentProps>(_EuiComponent)`
var withEuiTheme = function withEuiTheme(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithTheme';
  var Render = function Render(props, ref) {
    var theme = useEuiTheme();
    return (0, _react2.jsx)(Component, _extends({
      theme: theme,
      ref: ref
    }, props));
  };
  var WithEuiTheme = /*#__PURE__*/(0, _react.forwardRef)(Render);
  WithEuiTheme.displayName = componentName;
  return WithEuiTheme;
};

/**
 * Render prop alternative for complex class components
 * Most useful for scenarios where a HOC may interfere with typing
 */
exports.withEuiTheme = withEuiTheme;
var RenderWithEuiTheme = function RenderWithEuiTheme(_ref) {
  var children = _ref.children;
  var theme = useEuiTheme();
  return children(theme);
};

/**
 * Minor syntactical sugar hook for theme CSS variables.
 * Primarily meant for internal EUI usage.
 */
exports.RenderWithEuiTheme = RenderWithEuiTheme;
var useEuiThemeCSSVariables = function useEuiThemeCSSVariables() {
  var _useContext = (0, _react.useContext)(_context.EuiNestedThemeContext),
    setGlobalCSSVariables = _useContext.setGlobalCSSVariables,
    globalCSSVariables = _useContext.globalCSSVariables,
    setNearestThemeCSSVariables = _useContext.setNearestThemeCSSVariables,
    themeCSSVariables = _useContext.themeCSSVariables;
  return {
    setGlobalCSSVariables: setGlobalCSSVariables,
    globalCSSVariables: globalCSSVariables,
    setNearestThemeCSSVariables: setNearestThemeCSSVariables,
    themeCSSVariables: themeCSSVariables
  };
};
exports.useEuiThemeCSSVariables = useEuiThemeCSSVariables;