"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GUTTER_SIZES = exports.EuiTimeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _timeline_item = require("./timeline_item");
var _timeline = require("./timeline.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "items", "children", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var GUTTER_SIZES = ['m', 'l', 'xl'];
exports.GUTTER_SIZES = GUTTER_SIZES;
var EuiTimeline = function EuiTimeline(_ref) {
  var className = _ref.className,
    _ref$items = _ref.items,
    items = _ref$items === void 0 ? [] : _ref$items,
    children = _ref.children,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'xl' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiTimeline', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _timeline.euiTimelineStyles)(euiTheme);
  var cssStyles = [styles.euiTimeline, styles[gutterSize]];
  return (
    // eslint-disable-next-line jsx-a11y/no-redundant-roles
    (0, _react2.jsx)("ol", _extends({
      className: classes,
      css: cssStyles,
      role: "list"
    }, rest), items.map(function (item, index) {
      return (0, _react2.jsx)(_timeline_item.EuiTimelineItem, _extends({
        key: index
      }, item));
    }), children)
  );
};
exports.EuiTimeline = EuiTimeline;
EuiTimeline.propTypes = {
  /**
     * List of timeline items to render. See #EuiTimelineItem
     */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Vertical alignment of the event with the icon
       */
    verticalAlign: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Sets the size of the vertical space between each timeline item
     */
  gutterSize: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};