"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSearchBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _form = require("../form");
var _popover = require("../popover");
var _react2 = require("@emotion/react");
var _excluded = ["query", "placeholder", "incremental", "hint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiSearchBox = function EuiSearchBox(_ref) {
  var query = _ref.query,
    placeholder = _ref.placeholder,
    incremental = _ref.incremental,
    hint = _ref.hint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _inputRef = (0, _react.useRef)(null);
  (0, _services.useUpdateEffect)(function () {
    if (_inputRef.current) {
      _inputRef.current.value = query;
      _inputRef.current.dispatchEvent(new Event('change'));
    }
  }, [query]);
  var defaultPlaceholder = (0, _i18n.useEuiI18n)('euiSearchBox.placeholder', 'Search...');
  var ariaLabelIncremental = (0, _i18n.useEuiI18n)('euiSearchBox.incrementalAriaLabel', 'This is a search bar. As you type, the results lower in the page will automatically filter.');
  var ariaLabelEnter = (0, _i18n.useEuiI18n)('euiSearchBox.ariaLabel', 'This is a search bar. After typing your query, hit enter to filter the results lower in the page.');
  var search = (0, _react2.jsx)(_form.EuiFieldSearch, _extends({
    inputRef: function inputRef(input) {
      return _inputRef.current = input;
    },
    fullWidth: true,
    defaultValue: query,
    incremental: incremental,
    "aria-label": incremental ? ariaLabelIncremental : ariaLabelEnter,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    onFocus: function onFocus() {
      hint === null || hint === void 0 ? void 0 : hint.setIsVisible(true);
    }
  }, rest));
  if (hint) {
    return (0, _react2.jsx)(_popover.EuiInputPopover, _extends({
      disableFocusTrap: true,
      input: search,
      isOpen: hint.isVisible,
      fullWidth: true,
      closePopover: function closePopover() {
        hint.setIsVisible(false);
      },
      panelProps: {
        'aria-live': undefined,
        'aria-modal': undefined,
        role: undefined,
        tabIndex: -1,
        id: hint.id
      }
    }, hint.popoverProps), hint.content);
  }
  return search;
};
exports.EuiSearchBox = EuiSearchBox;
EuiSearchBox.propTypes = {
  query: _propTypes.default.string.isRequired,
  // This is optional in EuiFieldSearchProps
  onSearch: _propTypes.default.func.isRequired,
  /**
     * @default Search...
     */
  placeholder: _propTypes.default.string,
  hint: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    isVisible: _propTypes.default.bool.isRequired,
    setIsVisible: _propTypes.default.func.isRequired,
    content: _propTypes.default.node.isRequired,
    popoverProps: _propTypes.default.any
  })
};